#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "arbitrary.h"
#include <time.h>

int main(int argc, char** argv) {
	
	arb_int n;
	if(argc>1) {
		//take 1st argument: n
		set(&n, argv[1]);
	
		clock_t start = clock();
		arb_int fac;
		arb_int i;
		set(&fac, "1");
		set(&i, "1");
		if(strcmp(n, "0")!=0) {
			while(strcmp(n, i)) {
				i = add(i, "1");
				fac = mult(fac, i);
			}	
		}
		clock_t end = clock();

		printf("%s! = \n%s\n", n, fac);	
		printf("\nLaufzeit: %.2fs\n", (float)(end-start)/CLOCKS_PER_SEC);
	} else {
		printf("Usage: faculty N\n");
	}
	return 0;
}
