#include "arbitrary.h"

#include <string.h>
#include <stdlib.h>

#define ARB_INT( l ) ( sizeof(arb_digit)*(l+1) )

void set(arb_int* var, const char *value) {
	*var = malloc(ARB_INT(strlen(value)));
	
	strcpy(*var, value);
}

void unset(arb_int* var) {
	free(*var);
}

arb_int add(arb_int a, arb_int b) {
	int l1 = strlen(a);
	int l2 = strlen(b);
	
	int l = (l1 > l2) ? l1 : l2;
	int d = (l1 > l2) ? l2 : l1;

	arb_int sum = malloc(ARB_INT(l));
	
	if(l1 > l2) {
		strcpy(sum, a);
	} else {
		strcpy(sum, b);	
	}
	
	int i; int c=0; //c=carry
	for(i = 1; i<=l; i++) {
		if(i<=d)
		{
			char s = (a[l1-i]-'0' + b[l2-i]-'0') + c;
			c = (s>9)? 1:0;
			sum[l-i] = (s%10)+'0';
		} else {
			if(c==0) {
				break;
			} else {
				char s = sum[l-i]- '0' + c;
				c = (s>9)? 1:0;
				sum[l-i] = (s%10)+'0';
			}
		}

	} 
	if(c!=0) {
		arb_int ret = malloc(ARB_INT(l+1));
		ret[0]='1';
		strcpy(ret+1, sum);
		free(sum);
		return ret;	
	} 
	return sum;		
}

arb_int mult(arb_int a, arb_int b) {
	int l1 = strlen(a);
	int l2 = strlen(b);
	
	int l = l1+l2;
	
	arb_int prod = malloc(ARB_INT(l));
	for(int i=0;i<l; i++)
		prod[i]='0';
	prod[l]='\0';
	
	int c=0;
	for(int i=1; i<=l2; i++)
	{
		for(int j=1; j<=l1; j++)
		{
			int p = (b[l2-i]-'0')*(a[l1-j]-'0');
			int x = l - (i + (j-1));
			int s = (prod[x]-'0')+(p%10)+c;
			c=(s>9)? (s/10)+(p/10) : (p/10);
			prod[x] = (s%10)+'0';
			
			if(j==l1 && c!=0) {
				prod[x-1]=c+'0';
				c=0;				
			}
		}
		
		
	
	}
	//shift 0's:
	while(prod[0] == '0' && l>1) 
	{
		prod++; l--;
	}
	return prod;
}

